<?php 
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?id=34&alias=linee-guida-per-l%2527uso-del-logo-geecom
    */

    include "include/includeBase.php";    
    include "../classi/Menu.php";
    include "include/controlloLogin.php";
    // gli utenti di tipo articolista non possono accedere a questa pagina
    if($_SESSION["geecomAdmin_ruolo"]=="articolista") {
        header("Location: {$percorsoBase}index.php");
        exit();
    }
    
    if(isset($_GET["id"])) {
        $idMenu    = filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT);
        $menu      = new Menu($geecomDb, $idMenu);
        $menu->caricaDatiDalDatabase();
    }
    
    $tipiMenu = array("link","link a un contenuto","Link logout","menu a tendina","voce sottomenu");
    $datiGeecomAdmin = $geecomDb->leggiSingolaRiga("geec_prodotti", 2);
    if($datiGeecomAdmin["installato"]=="si") {                    
        $tipiMenu["linkGeecomAdmin"] = "Collegamento con Geecom Admin";
    }

?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
        <title>Geecom Admin - Creazione menu</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
		<div class="container-fluid">
                    <div class="row">
                        <!-- Colonna principale -->
                        <div class="col py-4">
                            <div class="card mb-4 box-shadow-lite">
                                <div class="card-header py-2">
                                    <form name="formMenu" action="../controller/controllerMenu.php" method="POST">
                                        <div class="row">
                                            <input type="text" class="d-none" name="operazione" value="<?php echo(isset($menu) ? "modifica" : "crea")?>">
                                            <input type="text" class="d-none" name="id" value="<?php echo(isset($menu) ? $menu->getId() : "0")?>">
                                            <div class="col-3 col-lg-2">
                                                <h6 class="mt-2">Nome menu:</h6>
                                            </div>
                                            <div class="col-9 col-lg-4">
                                                <input type="text" class="form-control" id="nomeMenu" name="nome" aria-describedby="nome Menu" value="<?php echo(isset($menu) ? $menu->getNome() : "")?>" placeholder="es.: menu principale">
                                            </div>
                                            <div class="col-4 col-lg-2">
                                                <div class="form-group switch-container">
                                 
                                                </div>
                                            </div>
                                            <div class="col-8 col-lg-4 text-right">
                                                <a class="btn btn-outline-primary mt-2 mt-md-0" href="gestioneMenu.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                                <button class="btn btn-primary mt-2 mt-md-0"><i class="fas fa-check"></i> Salva</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <?php 
                                    if(isset($menu)) {
                                ?>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-4 col-xl-3 align-self-start sticky-top">
                                            <form>
                                                <div class="mb-4 add-box">
                                                    <h6 class="mb-3"> Aggiungi una voce di menu </h6>
                                                    <div class="options-box">
                                                        
                                                        <div class="form-group">
                                                            <select class="form-control" id="tipoVoceMenu" onchange="mostraCampi(this.value)">
                                                                <?php 
                                                                    foreach($tipiMenu as $tipo=>$nomeTipo) {
                                                                        echo"<option value=\"$tipo\">$nomeTipo</option>";
                                                                    }
                                                                ?>
                                                            </select>
                                                        </div>
                                                        
                                                        <div id="divIdContenuto" class="d-none">
                                                            <label for="nome-voce-menu-3">Contenuto</label>
                                                            <select class="selectpicker" id="idContenuto" name="idContenuto" data-width="100%" data-live-search="true" data-size="10">
                                                                <option value="0">Seleziona</option>
                                                                <?php
                                                                    $queryTag = "SELECT * FROM geecAd_contenuti WHERE titolo NOT LIKE '' AND alias NOT LIKE ''";
                                                                    $result   = $geecomDb->eseguiQueryLettura($queryTag);
                                                                    while($contenuto = $result->fetch_assoc()) {
                                                                        echo"<option value=\"{$contenuto["id"]}\" data-subtext=\"{$contenuto["tipo"]}\">{$contenuto["titolo"]}</option>";
                                                                    }
                                                                ?>
                                                            </select>
                                                        </div>
                                                        
                                                        <div class="form-group">
                                                            <label for="nome-voce-menu-1">Nome</label>
                                                            <input type="text" class="form-control" id="nomeVoceMenu" name="nome" placeholder="Nome">
                                                        </div>
                                                        
                                                        <div class="form-group">
                                                            <label for="nome-voce-menu-2">Icona</label>
                                                            <input type="text" class="form-control" id="iconaVoceMenu" name="icona" placeholder="Icona">
                                                        </div>
                                                        
                                                        <div class="form-group" id="divLinkMenu">
                                                            <label for="nome-voce-menu-3">Link</label>
                                                            <input type="text" class="form-control" name="link" value="http://" id="linkVoceMenu" placeholder="Link">
                                                        </div>
                                                        
                                                        <div class="d-none" id="divVocePadre">
                                                            <label for="nome-voce-menu-3">Voce padre</label>
                                                            <select class="form-control" id="idVocePadre" name="vocePadre" >
                                                                <option value="0">Seleziona</option>
                                                                <?php
                                                                    $queryTag = "SELECT * FROM geecAd_vociMenu WHERE idMenu=$idMenu AND tipo LIKE 'menu a tendina'";
                                                                    $result   = $geecomDb->eseguiQueryLettura($queryTag);
                                                                    while($voceMenu = $result->fetch_assoc()) {
                                                                        echo"<option value=\"{$voceMenu["id"]}\">{$voceMenu["nome"]}</option>";
                                                                    }
                                                                ?>
                                                            </select>
                                                        </div>
                                                        
                                                        <div class="form-group">
                                                            <label for="nome-voce-menu-3">Visibilità</label>
                                                            <select class="form-control" id="gruppoSpecifico" name="gruppoSpecifico" >
                                                                <option value="0">Tutti gli utenti</option>
                                                                <?php
                                                                    $queryTag = "SELECT * FROM geec_gruppi";
                                                                    $result   = $geecomDb->eseguiQueryLettura($queryTag);
                                                                    while($gruppo = $result->fetch_assoc()) {
                                                                        echo"<option value=\"{$gruppo["id"]}\">{$gruppo["nome"]}</option>";
                                                                    }
                                                                ?>
                                                            </select>
                                                        </div>
                                                        
                                                        <button type="button" class="btn btn-primary float-right" value="Crea"  onclick="creaVoceMenu()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                        <div class="col-sm-8 col-xl-9 mb-4 gerarchia-menu" id="elencoVociMenu">
                                            <?php 
                                                $menu->stampaVociMenu();
                                            ?>
                                        </div>

                                        <div class="col-12 text-right">
                                            <a class="btn btn-outline-primary" href="gestioneMenu.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                            <button type="button" class="btn btn-primary" onclick="document.formMenu.submit()"><i class="fas fa-check"></i> Salva</button>
                                        </div>
                                    </div>
                                </div>
                                <?php 
                                    }
                                ?>
                            </div>
                        </div><!-- /Colonna principale -->
                    </div>
		</div>
        </main>
        
        <?php 
            include "include/footer.php";
            
            include "include/modal/modalMenuComponenti.php";
                    
            include "include/modal/cambiaPassword.php";
            
            include "include/modal/operazioneCompletata.php";
        ?>
	  
        
	<!-- MODALS  -->
        <div class="modal fade" id="modalComponenteAggiornato" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content bg-transparent">
                    <div class="modal-body m-0 p-0">
                        <div class="alert alert-success p-3 mb-0">
                            Componente aggiornato con successo
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="modalEliminaElemento" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare la voce di menu?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center text-center">
                                <span class="align-self-center text-primary"><em id="nomeVoceMenuDaEliminare"></em></span>
                                <div id="tipoElementoDaEliminare"></div>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="voceMenuDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneVoceMenu()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
        <?php 
            if(isset($menu)) {
        ?>
        <div class="modal fade" id="modifica-voce-menu" tabindex="-1" role="dialog" aria-labelledby="modifica-voce-menu" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">Modifica la voce di menu</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form>
                            <input type="text" class="d-none" id="idVoceMenuDaModificare" name="id">
                            <div class="form-group">
                                <select class="form-control" id="tipoVoceMenuDaModificare" onchange="mostraCampiModalModifcaVoce(this.value)">
                                    <?php 
                                        foreach($tipiMenu as $tipo => $nomeTipo) {
                                            echo"<option value=\"$tipo\">$nomeTipo</option>";
                                        }
                                    ?>
                                </select>
                            </div>

                            <div id="divIdContenutoDaModificare" class="d-none">
                                <label for="nome-voce-menu-3">Contenuto</label>
                                <select class="form-control" id="idContenutoDaModificare" name="idContenuto" >
                                    <option value="0">Seleziona</option>
                                    <?php
                                        $queryTag = "SELECT * FROM geecAd_contenuti";
                                        $result   = $geecomDb->eseguiQueryLettura($queryTag);
                                        while($contenuto = $result->fetch_assoc()) {
                                            echo"<option value=\"{$contenuto["id"]}\">{$contenuto["titolo"]}</option>";
                                        }
                                    ?>
                                </select>
                            </div>

                            <div id="divIdCategoriaDaModificare" class="d-none">
                                <label for="nome-voce-menu-3">Categoria</label>
                                <select class="form-control" id="idCategoriaDaModificare" name="idCategoria" >
                                    <option value="0">Seleziona</option>
                                    <?php
                                        $queryTag = "SELECT * FROM geec_categorie";
                                        $result   = $geecomDb->eseguiQueryLettura($queryTag);
                                        while($categoria = $result->fetch_assoc()) {
                                            echo"<option value=\"{$categoria["id"]}\">{$categoria["nome"]}</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="nome-voce-menu-1">Nome</label>
                                <input type="text" class="form-control" id="nomeVoceMenuDaModificare" name="nome" placeholder="Nome">
                            </div>

                            <div class="form-group">
                                <label for="nome-voce-menu-2">Icona</label>
                                <input type="text" class="form-control" id="iconaVoceMenuDaModificare" name="icona" placeholder="Icona">
                            </div>

                            <div class="form-group" id="divLinkMenuDaModificare">
                                <label for="nome-voce-menu-3">Link</label>
                                <input type="text" class="form-control" name="link" id="linkVoceMenuDaModificare" placeholder="Link">
                            </div>

                            <div class="d-none" id="divVocePadreDaModificare">
                                <label for="nome-voce-menu-3">Voce padre</label>
                                <select class="form-control" id="idVocePadre" name="vocePadre" >
                                    <?php
                                        $queryTag = "SELECT * FROM geecAd_vociMenu WHERE idMenu=$idMenu AND tipo LIKE 'menu a tendina'";
                                        $result   = $geecomDb->eseguiQueryLettura($queryTag);
                                        while($voceMenu = $result->fetch_assoc()) {
                                            echo"<option value=\"{$voceMenu["id"]}\">{$voceMenu["nome"]}</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                      </form>
                    </div>
                    <div class="modal-footer">
                          <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                          <button type="button" class="btn btn-primary btn-sm" onclick="eseguiModificaVoceMenu()"><i class="fas fa-check"></i> Salva</button>
                    </div>
                </div>
            </div>
        </div>    
        <?php
            }
            include "include/jsBaseAreaAmministrativa.php";
        ?>
        <!-- Dropzone -->


        <script>
            
            function modificaImpostazioniSezione() {
                $('#modifica-impostazioni-sezione').modal('show');
            }
            
            function eliminaComponentePagina(id,immagineComponente,nomeComponente,nomeElemento) {
                $('#componenteDaEliminare').val(id);
                document.getElementById("immagineComponenteDaEliminare").src = immagineComponente;
                $('#nomeComponenteDaEliminare').text(nomeComponente);
                document.getElementById("nomeVoceMenuDaEliminare").innerHTML = nomeElemento;
                $('#modalEliminaComponente').modal('show');
            }
            
            function eseguiEliminazioneComponentePagina() {
                var id = $('#componenteDaEliminare').val();
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaComponente",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("componentePagina"+id).className = "d-none";
                            $('#modalEliminaComponente').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function cambiaIdElemento(idComponente) {
                var idElemento = $("#idElementoComponente"+idComponente).val();
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"cambiaIdElemento",
                        id:idComponente,
                        idElemento:idElemento
                    },
                    success:function(result) {
                        if(result=="ok") {
                            $('#modalComponenteAggiornato').modal('show');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            //questa funzione viene usata quando si crea una voce di menu, fa comparire i campi necessari in
            //base al tipo di menu scelto. Si attiva ogni volta che la select tipo cambia valores
            function mostraCampi(scelta) {
                document.getElementById("divLinkMenu").className = "d-none";
                document.getElementById("divVocePadre").className = "d-none";
                document.getElementById("divIdContenuto").className = "d-none";
                
                if(scelta=="menu a tendina") {
                    //nessuna azione necessaria, i div non devono essere visibili
                }
                else if(scelta=="link a un contenuto") {
                    document.getElementById("divIdContenuto").className  = "form-group";
                }
                else if(scelta=="voce sottomenu") {
                    document.getElementById("divLinkMenu").className  = "form-group";
                    document.getElementById("divVocePadre").className = "form-group";
                }
                else if(scelta=="link immagine") {
                    document.getElementById("divLinkMenu").className  = "form-group";
                }
                else if(scelta=="mega menu") {
                    
                }
                else { //scelta = link
                    document.getElementById("divLinkMenu").className  = "form-group";
                }
            }
            
            function mostraCampiModalModifcaVoce(scelta) {
                document.getElementById("divLinkMenuDaModificare").className = "d-none";
                document.getElementById("divVocePadreDaModificare").className = "d-none";
                document.getElementById("divIdContenutoDaModificare").className = "d-none";
                document.getElementById("divIdCategoriaDaModificare").className = "d-none";
                
                if(scelta=="menu a tendina") {
                    //nessuna azione necessaria, i div non devono essere visibili
                }
                else if(scelta=="link a un contenuto") {
                    document.getElementById("divIdContenutoDaModificare").className  = "form-group";
                }
                else if(scelta=="link a una categoria") {
                    document.getElementById("divIdCategoriaDaModificare").className  = "form-group";
                }
                else if(scelta=="voce sottomenu") {
                    document.getElementById("divLinkMenuDaModificare").className  = "form-group";
                    document.getElementById("divVocePadreDaModificare").className = "form-group";
                }
                else if(scelta=="link immagine") {
                    document.getElementById("divLinkMenuDaModificare").className  = "form-group";
                }
                else { //scelta = link
                    document.getElementById("divLinkMenuDaModificare").className  = "form-group";
                }
            }
            
            function creaVoceMenu() {
                var tipo  = $('#tipoVoceMenu').val();
                var idContenuto = $('#idContenuto').val();
                var nome  = $('#nomeVoceMenu').val();
                var icona = $('#iconaVoceMenu').val();
                var link  = $('#linkVoceMenu').val();
                var vocePadre       = $('#idVocePadre').val();
                var gruppoSpecifico = $('#gruppoSpecifico').val();
                
                if(nome=="" && icona=="") {
                    alert("Inserisci almeno un nome o un'icona");
                }
                else {
                    
                    $.ajax({
                        type:"POST",
                        url:"../controller/controllerMenu.php",
                        data:{
                            operazione:"creaVoceMenu",
                            id:<?= $menu->getId() ?>,
                            idContenuto:idContenuto,
                            tipo:tipo,
                            nome:nome,
                            icona:icona,
                            link:link,
                            gruppoSpecifico:gruppoSpecifico,
                            vocePadre:vocePadre,
                        },
                        success:function(codiceHtml) {
                            var elencoVociMenu = document.getElementById("elencoVociMenu");
                            elencoVociMenu.innerHTML = elencoVociMenu.innerHTML + codiceHtml;
                            if(tipo=="menu a tendina" || tipo=="voce sottomenu") {
                                location.reload();
                            }
                        },
                        error: function() {
                            alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                        }
                    });
                }
            }
          
            function modificaVoceMenu(id,idContenuto,nome,icona,link,tipo) {
                $('#idVoceMenuDaModificare').val(id);
                $('#tipoVoceMenuDaModificare').val(tipo);
                $('#idContenutoDaModificare').val(idContenuto);
                
                if(tipo=="link a una categoria") {
                    $('#idCategoriaDaModificare').val(idContenuto);
                }
                
                $('#nomeVoceMenuDaModificare').val(nome);
                $('#iconaVoceMenuDaModificare').val(icona);
                $('#linkVoceMenuDaModificare').val(link);
                $('#modifica-voce-menu').modal('show');
            }
       
            function eseguiModificaVoceMenu() {
                var id = $('#idVoceMenuDaModificare').val();
                var tipo  = $('#tipoVoceMenuDaModificare').val();
                var idContenuto = $('#idContenutoDaModificare').val();
                var idCategoria = $('#idCategoriaDaModificare').val();
                var nome  = $('#nomeVoceMenuDaModificare').val();
                var icona = $('#iconaVoceMenuDaModificare').val();
                var link  = $('#linkVoceMenuDaModificare').val();
                
                if(tipo=="link a una categoria") {
                    idContenuto = idCategoria; // l'id della categoria viene trasmesso nella variabile idContenuto
                }
                
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerMenu.php",
                    data:{
                        operazione:"modificaVoceMenu",
                        id:<?php echo $menu->getId() ?>,
                        idVoceMenu:id,
                        idContenuto:idContenuto,
                        tipo:tipo,
                        nome:nome,
                        icona:icona,
                        link:link
                    },
                    success:function(esito) {
                        if(esito==="ok" && tipo==="menu a tendina") {
                            location.reload();
                        }
                        else if(esito==="ok") {
                            aggiornaElencoVociMenu();
                        }
                        else {
                            alert(result)
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
               
            function spostaVoceMenuInput(id) {
                var posizione = $('#nuovaPosizioneVoceMenu'+id).val();
                spostaVoceMenu(id,posizione);
            }
            
            function spostaVoceMenu(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerMenu.php",
                    data:{
                        operazione:"spostaVoceMenu",
                        id:<?php echo $menu->getId() ?>,
                        idVoce:id,
                        posizione:posizione
                    },
                    success:function(result) {
                        if(result=="ok") {
                            aggiornaElencoVociMenu();
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaElencoVociMenu() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerMenu.php",
                    data:{
                        operazione:"stampaVociMenu",
                        id:<?php echo $menu->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("elencoVociMenu").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eliminaVoceMenu(id,nomeElemento,tipoElemento) {
                $('#voceMenuDaEliminare').val(id);
                $('#nomeVoceMenuDaEliminare').text(nomeElemento);
                document.getElementById("tipoElementoDaEliminare").innerHTML = tipoElemento;
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneVoceMenu() {
                var id = $('#voceMenuDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerMenu.php",
                    data:{
                        operazione:"eliminaVoceMenu",
                        id:<?php echo $menu->getId() ?>,
                        idVoceMenu:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("voceMenu"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDatiMegaMenu(idVoceMegaMenu) {
                var testo             = document.getElementById("testoMegaMenu"+idVoceMegaMenu).value;
                var mostraNomiColonne = "no";
                if(document.getElementById("mostraNomiColonne"+idVoceMegaMenu).checked) {
                    mostraNomiColonne = "si";
                }
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerMenu.php",
                    data:{
                        operazione:"aggiornaDatiMegaMenu",
                        id:<?php echo $menu->getId() ?>,
                        idVoceMegaMenu:idVoceMegaMenu,
                        testoAssociato:testo,
                        mostraNomiColonne:mostraNomiColonne
                    },
                    success:function(result) {
                        if(result=="ok") {
                            $('#labelOperazioneCompletata').text("Mega menu aggiornato");
                            $('#modalOperazioneCompletata').modal('show');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
  </body>
</html>
